
local math,vectorMath,video = math,vectorMath,video

-- global render physics method
function renderPhysicsLines(cx, cy, definition, scale, angle, color)

	local a,r,g,b = 255, 255, 255, 255
	if color then
		a, r, g, b = color.a, color.r, color.g, color.b
	end
	
	if not definition.shapes then
		return
	end
	for index, phys in pairs(definition.shapes) do
		if phys.shape == "poly" then
			local sx,sy = vectorMath.rotate(phys.x[1] * scale, phys.y[1] * scale, angle)
			local x, y = sx, sy
			for pindex=2,#phys.x do
				local nx,ny = vectorMath.rotate(phys.x[pindex] * scale, phys.y[pindex] * scale, angle)
				video.renderLine(cx + x, cy + y, cx + nx, cy + ny, a, r, g, b)
				x,y = nx, ny
			end
			video.renderLine(cx + x, cy + y, cx + sx, cy + sy, a, r, g, b)
		elseif phys.shape == "box" then
			
			local ox, oy = vectorMath.rotate(phys.ox * scale, phys.oy * scale, angle)
			local sx,sy = vectorMath.rotate(-phys.width * scale * .5, -phys.height * scale * .5, angle)
			sx,sy = sx + ox, sy + oy
			local ex,ey = vectorMath.rotate(phys.width * scale * .5, -phys.height * scale * .5, angle)
			ex,ey = ex + ox, ey + oy
			video.renderLine(cx + sx, cy + sy, cx + ex, cy + ey, a, r, g, b)
			
			sx,sy = ex,ey
			ex,ey = vectorMath.rotate(phys.width * scale * .5, phys.height * scale * .5, angle)
			ex,ey = ex + ox, ey + oy
			video.renderLine(cx + sx, cy + sy, cx + ex, cy + ey, a, r, g, b)
			
			sx,sy = ex,ey
			ex,ey = vectorMath.rotate(-phys.width * scale * .5, phys.height * scale * .5, angle)
			ex,ey = ex + ox, ey + oy
			video.renderLine(cx + sx, cy + sy, cx + ex, cy + ey, a, r, g, b)
			
			sx,sy = ex,ey
			ex,ey = vectorMath.rotate(-phys.width * scale * .5, -phys.height * scale * .5, angle)
			ex,ey = ex + ox, ey + oy
			video.renderLine(cx + sx, cy + sy, cx + ex, cy + ey, a, r, g, b)
		elseif phys.shape == "circle" then
			local ox = math.cos(angle) * phys.ox*flip + math.cos(angle+math.pi*0.5)*  phys.oy
			local oy = math.sin(angle+math.pi*0.5) * phys.oy + math.sin(angle) * phys.ox*flip
			
			local segs  = math.ceil(math.max(9,radius*math.pi*2/10))
			for a=0,(segs-1) do
				local sx,sy = math.cos(a * math.pi * 2 / segs + angle) * phys.radius * scale, math.sin(a * math.pi * 2 / segs + angle) * phys.radius * scale
				local ex,ey = math.cos((a+1) * math.pi * 2 / segs + angle) * phys.radius * scale, math.sin((a+1) * math.pi * 2 / segs + angle) * phys.radius * scale
				video.renderLine(cx + sx+ ox, cy + sy + oy, cx + ex + ox, cy + ey + oy, alpha, r, g, b)
				if a == 0 then
					local sxd,syd = math.cos(a * math.pi * 2 / segs + angle) * phys.radius * scale*0.5, math.sin(a * math.pi * 2 / segs + angle) * phys.radius * scale*0.5
					video.renderLine(cx + sx+ ox, cy + sy + oy, cx + sxd + ox, cy + syd + oy, alpha*0.75, r, g, b)
				end
			end
		elseif phys.shape == "edge" then
			local sx,sy = vectorMath.rotate(phys.startX * scale, phys.startY * scale, angle)
			local ex,ey = vectorMath.rotate(phys.endX * scale, phys.endY * scale, angle)
			
			video.renderLine(cx + sx, cy + sy, cx + ex, cy + ey, a, r, g, b)
		end
	end
	
end
